package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.json.DocumentReviewNoteView;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import com.ibm.icu.text.SimpleDateFormat;

public class TestDocumentReviewNoteViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		DocumentReviewNoteViewBuilder builder = new DocumentReviewNoteViewBuilder();
		
		try {
			builder.build((RequestLocationDocumentSummary)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		RequestLocationDocumentSummary rlds = new RequestLocationDocumentSummary();
		rlds.setDocumentId(1);
		rlds.setReviewNoteCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		rlds.setReviewNote("note");
		
		DocumentReviewNoteView drnv = builder.build(rlds);
		Assert.assertNotNull(drnv);
		Assert.assertEquals(drnv.getDocumentId(), 1);
		Assert.assertEquals(drnv.getNote(), "note");
		
		// verify that the date is formatted MM/dd/yy hh:mmaa
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mmaa");
		java.util.Date date = sdf.parse(drnv.getCreated());
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		GregorianCalendar currCalendar = new GregorianCalendar();
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));
	}
	
	@Test
	public void testTwo() throws Exception {
		DocumentReviewNoteViewBuilder builder = new DocumentReviewNoteViewBuilder();
		
		try {
			builder.build((RequestParticipantDocumentSummary)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		RequestParticipantDocumentSummary rpds = new RequestParticipantDocumentSummary();
		rpds.setDocumentId(1);
		rpds.setReviewNoteCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		rpds.setReviewNote("note");
		
		DocumentReviewNoteView drnv = builder.build(rpds);
		Assert.assertNotNull(drnv);
		Assert.assertEquals(drnv.getDocumentId(), 1);

		// verify that the date is formatted MM/dd/yy hh:mmaa
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mmaa");
		java.util.Date date = sdf.parse(drnv.getCreated());
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		GregorianCalendar currCalendar = new GregorianCalendar();
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));
	}
}
